%% COMANDI DI PULIZIA E VISUALIZZAZIONE DATI
clc
clear all
close all
set(0,'defaultTextInterpreter','latex');          % serve a settare i grafici nei plot
set(0,'defaultAxesFontSize',20);
set(0,'defaultAxesFontName','TimesNewRoman');

%% COSTANTI FISICHE
T=293;          % Temperatura ambiente assoluta [K]
mu=1.81e-5;     % viscosit` dinamica dell'aria a 0 C [Pas]
R=287.053;      % Costante dell'aria [J/Kg/K]
Pa=101325;         % Pressione ambiente a 293 K [Pa]
Ps=5.1e5;
b_c=0.5283;

Kt=sqrt(293/T);          %Fattore di correzione della temperatura
rho=Pa/(R*T);           %Densità dell'aria in condizioni normali (kg/m^3)
psi=0.6855/sqrt(R*T);   %Costante nella formula ISO 6358
cost=1/(24*mu*R*T);     %Costante nella formula della portata in uscita dal meato

dt=1e-7;        % Time Step (Eulero esplicito)
ck=60000/rho;   % Per passare da (kg/s) a (l/min) ANR 
g=9.806;        % Acclerazione gravitazionale (m/s^2)

%% Geometria pattino
n_fori=4;       % numero di fori del pattino
dp=1.05e-3;        % diametro del foro di ingresso del pattino 
hg=54e-6;       % profondità media ragnatura
wg=0.16e-3;      % larghezza ragnatura
L=60e-3;
B=30e-3;
l=45e-3;
b=20e-3;
lx=(L-l)/2;
ly=(B-b)/2;
coeff=1;
A=L*B*coeff;            % Aumentando coeff gira più veloce (equivale ad aumentare il passo di tempo)
Vg=1/2*wg*hg*2*(l+b);     % volume ragnatura

% IMPOSTARE   "d_ratio" e "h_des" messi nel "Mod_0_project"
dn=0.75e-3;                      % diametro dell'ugello
d_ratio=dn/dp;
% h_des=20.1;

%% PARAMETRI DELLA VALVOLA
dm=6e-3;                            % diametro membrana metallica m
x_bypass=13;   %    [um]

% mettere i valori ottenuti dal Modello "0" di progetto
% xn=     -2.2739e-06;
% km=      1.5984e+05;
xn=     -2.2739e-06;
km=      1.5984e+05;


d_con=5e-3;                         % diametro dei condotti interni al pattino
V_valvola=(6e-3-3.75e-3)^2*pi/4*3.9e-3+(1.875e-3)^2*pi/4*(9)*1e-3;         % Volume della valvola
V_pat_pieno=B*L*12e-3;
V_pat_vuoto=20902.613e-9;  %calcolato con inventor
V_pattino=V_pat_pieno-V_pat_vuoto;   % volume dei condotti interni al pattino
V_cavo=pi*(2e-3)^2/4*62e-3;         % volume del tubo tra valvola e pattino
V1=V_valvola+V_pattino+V_cavo;         % volume a monte del pattino
S_eqv=(l*b+L*B+0.5*(L*b+B*l))/3;        % superficie equivalente su cui insiste la Fp considerando una distribuz. di pressione a tronco di piramide

c_num=0;

%% PARAMETRI TEMPO DIPENDENTI
%Reynolds Conduttanze 
   RRe1t=[];
   RRe2t=[];
   Cda1t=[];
   Cda2t=[];
   Cs1t=[];
   Cs2t=[];
   %Pressioni
   P1t=[];
   P2t=[];
   P0t=[];
% Caratteristiche pattino + valvola 
   H0t=[];
   H_dott=[];
   Xvt=[];
   G1t=[];
   G2t=[];
   G3t=[];
   Fmt=[];
   time=[];
   FFextt=[];
%% CALCOLO DEL PRIMO PUNTO DI FUNZIONAMENTO
h0=4*1e-6;
%% Inizializzazione Parametri del Modello
p1=Ps; % [Pa]
p2=Ps;
p0=Ps;
Re1=0;
Re2=0;
Fp0=0;
err_Fp=10;
err_G=10;
g30=0;
j=0;
toll=1e-9;

V0=h0*l*b;      % volume del meato (costante)
V2=V0+Vg;       % volume tot. = volume meato + volume ragnatura (costante)

tic
while (abs(err_Fp)>toll || abs(err_G)>toll)
j=j+1;

% Calcolo la distanza ugello-membrana
x=xn+(p1-Pa)*(pi*dm^2/4)/km;
% Verifico se sono in condizioni di x_bypass o meno
if x<x_bypass*1e-6
   x=x_bypass*1e-6;
end

% Calcolo la conduttanza dell'ugello della valvola (considero la sezione ANULARE)
cda1=1.05*(1-0.3*exp(-0.005*Re1));
C1=cda1*(pi*x*dn)*Kt*psi;      % conduttanza dell'ugello della valvola con sezione ANULARE

% Calcolo la portata dell'ugello della valvola g1
[g1]=FORO(C1,Ps,p1);        % portata attraverso l'ugello della valvola calcolata con la function FORO 
g1=g1*Kt;
Re1=abs(g1)/(pi*mu*dn);

% Calcolo la conduttanza del foro del pattino (considero la sezione ANULARE)
cda2=1.05*(1-0.3*exp(-0.005*Re2));
C2=cda2*(pi*h0*dp+wg*hg)*Kt*psi;   % conduttanza di un foro del pattino
[g2]=FORO(C2,p1,p2);             % portata attraverso un foro del pattino
g2=g2*Kt;
heq=(pi*h0*dp+hg*wg)/(pi*dp);
Re2=abs(g2)*h0/(pi*dp*mu*heq);

% Portate in uscita dal pattino
gx=cost*(h0)^3*((p0^2-Pa^2)/lx)*b;
gy=cost*(h0)^3*((p0^2-Pa^2)/ly)*l;
g3=2*(gx+gy);  

% Calcolo le pressioni p1, p0 e p2
p1=p1+(g1-g2*n_fori)*dt*R*T/V1;       % applico Eulero esplicito in avanti
p0=p0+(g2*n_fori-g3)*dt*R*T/V2;       % applico Eulero esplicito in avanti

hum=h0*1e6;
af=0.14;
bf=5;
f=1-af^(bf/hum);        % f=p0/p2;
p2=(1/f)*(p0-Pa)+Pa;   % formula inversa per trovare p2

% Calcolo la forza di pressione Fp dovuta al meato
Fp=S_eqv*(p0-Pa);

% calcolo gli errori per uscire dal while
err_Fp=(Fp-Fp0)/Fp;
err_G=(g3-g30)/g3;
            
Fp0=Fp;
g30=g3;
end
     toc
    
%% CALCOLO DEGLI ALTRI PUNTI DI FUNZIONAMENTO NOTO IL CARICO IMPOSTO

i=0;
contatore=0; %Conta ogni quanto salvare i risultati delle simulazioni nel tempo (ogni punti)
F_EXT=[Fp:-20:400];
Frequenze=linspace(5,100,50);
% Frequenze=[5 10 15 20 30];
omega=2*pi*Frequenze;

for i=1:length(F_EXT)

    h0_dot=0;   % condizione iniziale di velocità --> mi serve per Eulero esplicito in avanti
    err_Fp=10;
    err_G=10;
    err_h=10;
    F_ext=F_EXT(i);
    M(i)=F_ext/g;          % massa supportata dal pattino
    
    tic
while (abs(err_Fp)>toll || abs(err_h)>toll)

j=j+1;
contatore=contatore+1;

% Calcolo distanza ugello-membrana
x=xn+(p1-Pa)*pi*dm^2/4/km;

%Caso bypass
if x<x_bypass*1e-6
   x=x_bypass*1e-6;
end

% Conduttanza ugello valvola (si una la sezione anulare)
cda1=1.05*(1-0.3*exp(-0.005*Re1));
C1=cda1*(pi*x*dn)*Kt*psi;    %conduttanza foro valvola con area anulare

%Calcolo portata ugello valvola
[g1]=FORO(C1,Ps,p1);      %portata attraverso l'ugello della valvola   (kg/s)
Re1=abs(g1)/(pi*mu*dn);

%Conduttanza foro pattino (si una la sezione anulare)
cda2=1.05*(1-0.3*exp(-0.005*Re2));
C2=cda2*(pi*h0*dp+wg*hg)*Kt*psi;   %conduttanza di un foro del pattino
[g2]=FORO(C2,p1,p2);             %portata attraverso un foro del pattino    (kg/s)
heq=(pi*h0*dp+hg*wg)/(pi*dp);
Re2=abs(g2)*h0/(pi*dp*mu*heq);

%Portate uscita meato
gx=cost*(h0)^3*((p0^2-Pa^2)/lx)*b;
gy=cost*(h0)^3*((p0^2-Pa^2)/ly)*l;
g3=2*(gx+gy);

%Calcolo forza e nuovo meato di equilibrio
Fp=S_eqv*(p0-Pa);
% h1_dot=h0_dot+dt/M(i)*(Fp-F_ext);       % Eulero esplicito in avanti
h1_dot=h0_dot+dt/M(i)*(Fp-F_ext-c_num*h0_dot);       % Eulero esplicito in avanti
h1=h0+h0_dot*dt;                     % Eulero esplicito in avanti

%Calcolo Pressioni
V2=h0*l*b+Vg;
p1=p1+(g1-g2*n_fori)*dt*R*T/V1; % pattino attivo
p0=p0+((g2*n_fori-g3)-h0_dot*A*p0/(R*T))*dt*R*T/V2;

hum=h0*1e6;
af=0.14;
bf=5;
f=1-af^(bf/hum);        % f=p0/p2;
p2=(1/f)*(p0-Pa)+Pa;   % formula inversa per trovare p2

% Calcolo gli errori per uscire dal while
err_Fp=(Fp-F_ext)/F_ext;
err_G=(g3-g30)/g3;
err_h=(h1-h0)/h0;


Fp0=Fp;
g30=g3;
h0=h1;
h0_dot=h1_dot;
%% VARIABILI TEMPORALI (salvate ogni 2000 punti)
punti=2000;
if contatore==punti
% %Reynolds Conduttanze 
%    RRe1t=[RRe1t Re1];
%    RRe2t=[RRe2t Re2];
%    Cda1t=[Cda1t cda1];
%    Cda2t=[Cda2t cda2];
%    Cs1t=[Cs1t C1];
%    Cs2t=[Cs2t C2];
%  %Pressioni
%    P1t=[P1t p1];
%    P2t=[P2t p2];
%    P0t=[P0t p0];
%Caratteristiche pattino + valvola 
%    H0t=[H0t h0]; %(m)
%    H_dott=[H_dott h0_dot]; %(m/s)
%    Xvt=[Xvt x];
%    G1t=[G1t g1*ck];
%    G2t=[G2t g2*n_fori*ck];
%    G3t=[G3t g3*ck];
%    Fmt=[Fmt Fp];
%    time=[time dt*j];
%    FFextt=[FFextt F_ext];
   
   contatore=0;
end

end
% toc
%% VARIABILI CORRISPONDENTI AI PUNTI DI EQUILIBRIO
   %Reynolds Conduttanze 
   RRe1(i)=Re1;
   RRe2(i)=Re2;
   Cda1(i)=cda1;
   Cda2(i)=cda2;
   Cs1(i)=C1;
   Cs2(i)=C2;

   %Pressioni
   P1(i)=p1;
   P2(i)=p2;
   P0(i)=p0;

%Caratteristiche pattino + valvola 
   H0(i)=h0;
   H_dot(i)=h0_dot;
   Xv(i)=x;
   G1(i)=g1;
   G2(i)=g2;
   G3(i)=g3;
   Fm(i)=Fp;

%% 	CALCOLO COEFFICIENTI MODELLO LINEARIZZATO
s=tf('s');

%Costanti equazioni di continuità 1
g1c(i)=(V1+x*pi*dm^2/4)/(R*T);
g2c(i)=pi*dm^2/4*p1/(R*T);
%Costanti equazioni di continuità 2
l1(i)=p0*A/(R*T);
l2(i)=(A*h0+Vg)/(R*T);
  
%Derivate di G1(x,P1)
if p1/Ps>b_c
phi1(i)=(p1/Ps-b_c)/(1-b_c);
a1(i)=-Kt*cda1*psi*pi*dn*x*phi1(i)/sqrt(1-phi1(i)^2)/((1-b_c));
a2(i)=Kt*cda1*psi*pi*dn*Ps*sqrt(1-phi1(i)^2);
else
a1(i)=0;
a2(i)=Kt*cda1*psi*pi*dn*Ps;
end


%Derivate di G2(h,P1,P2)
if p2/p1>b_c
phi2(i)=(p2/p1-b_c)/(1-b_c);
b1(i)=Kt*cda2*psi*pi*dp*p1*sqrt(1-phi2(i)^2);
b2(i)=Kt*cda2*psi*(pi*dp*h0+wg*hg)*(sqrt(1-phi2(i)^2)+phi2(i)*p2/sqrt(1-phi2(i)^2)/p1/(1-b_c));
b3(i)=-Kt*cda2*psi*(pi*dp*h0+wg*hg)*phi2(i)/sqrt(1-phi2(i)^2)/(1-b_c);
else
b1(i)=Kt*cda2*psi*pi*dp*p1;
b2(i)=Kt*cda2*psi*(pi*dp*h0+wg*hg);
b3(i)=0;
end

%Derivate di G3(h,P0)
c1(i)=(p0^2-Pa^2)*h0^2*(b/(L-l)+l/(B-b))/(2*mu*R*T);
c2(i)=p0*h0^3*(b/(L-l)+l/(B-b))/(3*mu*R*T);

% %Derivate di P0(h,P2)
% % d1(i)=5*0.14^(5/H0_um(i))*log(0.14)*(P2(i)-Pa)/H0_um(i)^2 ;
% % d2(i)=(1-0.14^(5/H0_um(i)));
% d1(i)=bf*af^(bf/H0_um(i))*log(af)*(P2(i)-Pa)/H0_um(i)^2;
% d2(i)=(1-af^(bf/H0_um(i)));
%Derivate di x(P1)
if x<=x_bypass*1e-6
    f1(i)=0;
else
    f1(i)=(pi*dm^2)/(4*km);
    
end

%Coefficienti fdt
%k1=dP2/dP0
k1(i)=1/(1-af^(bf/hum));
% k2=dP2/dh
k2(i)=(-bf*log(af)*(p0-Pa)*af^(bf/hum))/(hum^2*(1-af^(bf/hum))^2)*1e6;
% g2c(i)=0;%smorzamento membrana


alfa2(i)=-g1c(i)*l1(i)-g2c(i)*f1(i)*l1(i);
alfa1(i)=4*(g1c(i)*b1(i)+g1c(i)*b3(i)*k2(i)+g2c(i)*f1(i)*b1(i)+g2c(i)*f1(i)*b3(i)*k2(i)-b2(i)*l1(i))-g1c(i)*c1(i)-g2c(i)*f1(i)*c1(i)+a1(i)*l1(i)+a2(i)*f1(i)*l1(i);
alfa0(i)= 4*(-a2(i)*f1(i)*b3(i)*k2(i)-a1(i)*b1(i)-a1(i)*b3(i)*k2(i)-a2(i)*f1(i)*b1(i)-b2(i)*c1(i))+a1(i)*c1(i)+a2(i)*f1(i)*c1(i);
     
beta2(i)=g1c(i)*l2(i) + g2c(i)*f1(i)*l2(i);
beta1(i)=4*(b2(i)*l2(i)-g1c(i)*b3(i)*k1(i)-b3(i)*g2c(i)*f1(i)*k1(i))+g1c(i)*c2(i)+c2(i)*g2c(i)*f1(i)-a1(i)*l2(i)-a2(i)*f1(i)*l2(i);
beta0(i)=4*(a1(i)*b3(i)*k1(i)+a2(i)*f1(i)*b3(i)*k1(i)+b2(i)*c2(i))-a1(i)*c2(i)-a2(i)*f1(i)*c2(i);
    

H_tf1(i)=-S_eqv*(alfa2(i)*s^2+alfa1(i)*s+alfa0(i))/(beta2(i)*s^2+beta1(i)*s+beta0(i));
H_tf(i)=minreal(H_tf1(i));
k_stLIN(i)=-S_eqv*alfa0(i)/beta0(i);


%invertire la fdt
%confronto a 1 HZ
[mag_Htf,phase_Htf]=bode(H_tf(i),omega);
mag_Htf=mag_Htf(:);
phase_Htf=phase_Htf(:);
MAG_Htf(i,:)=mag_Htf;
PHASE_Htf(i,:)=phase_Htf;

k_dynL=mag_Htf.*cosd(phase_Htf);
c_dynL=mag_Htf.*sind(phase_Htf)./omega';
K_dynL(i,:)=k_dynL;
C_dynL(i,:)=c_dynL;

G_tf(i)=1/(M(i)*s^2);
W_tf(i)=feedback(G_tf(i),H_tf(i));
[mag_Wtf,phase_Wtf]=bode(W_tf(i),omega);
mag_Wtf=mag_Wtf(:);
phase_Wtf=phase_Wtf(:);
MAG_Wtf(i,:)=mag_Wtf;
PHASE_Wtf(i,:)=phase_Wtf;

% [Yw(i),Tw(i)]=step(W_tf(i));

% 
% k_dynL=mag_Wtf.*cosd(phase_Wtf);
% c_dynL=mag_Wtf.*sind(phase_Wtf)./omega';
% K_dynL(i,:)=k_dynL;
% C_dynL(i,:)=c_dynL;
toc
end

% step(1/H_tf(4))

h_min=min(H0*1e6);
h_max=max(H0*1e6);
F_min=min(Fm);
F_max=max(Fm);

%% CAPACITA' DI CARICO
close all

% load Simul_Stat_Ps5

figure 
plot(H0*1e6,Fm,'b','linewidth',2),grid on, hold on,
% plot(H0_v_h10*1e6,Fm_v_h10,'b','linewidth',2),grid on, hold on,
xlabel(' Air \quad gap $\quad h$ $(\mu m) $'),
ylabel(' Force  $ \quad F$ $(N)$ '),
grid on, zoom on
xlim([h_min h_max]),


%%CONSUMO D'ARIA
figure 
plot(H0*1e6,G1*ck,'b','linewidth',2),grid on, hold on,
plot(H0*1e6,G2*ck*n_fori,'ro','linewidth',2),grid on, hold on,
plot(H0*1e6,G3*ck,'gx','linewidth',2),grid on, hold on,
% plot(H0_v_h10*1e6,G_v_h10,'ks','linewidth',2),grid on, hold on,
xlabel(' Air \quad gap $\quad h$ $(\mu m) $'),
ylabel('  Flow \quad Rate  \quad $Q$ $(\frac{l}{min} \quad ANR \quad 20^{\circ}$)'),
grid on, zoom on
xlim([h_min h_max])

% %% RIGIDEZZA STATICA
k_stNL=derivata(-Fm,H0);

figure 
plot(H0*1e6,k_stNL*1e-6,'rx','linewidth',2),grid on, hold on,
plot(H0*1e6,k_stLIN*1e-6,'b','linewidth',2),grid on, hold on,
% plot(H0_v_h10*1e6,ks_v_h10,'ks','linewidth',2),grid on, hold on,
xlabel(' Air \quad gap $\quad h$ $(\mu m) $'),
ylabel(' Stiffness  $ \quad k$ $(\frac{N}{\mu m})$ '),
grid on, zoom on
xlim([h_min h_max])

%% Dinamica

load Simul_Dyn_NL_Ps5


figure 
plot(H0*1e6,K_dynL(:,1),'b-','linewidth',2),grid on, hold on,
plot(H0_Ps5,k_NL_Ps5(:,1),'ro-','linewidth',2),grid on, hold on,
xlabel(' Air \quad gap $\quad h$ $(\mu m) $'),
ylabel(' Stiffness  $ \quad k$ $(\frac{N}{m})$ '),
grid on, zoom on
xlim([h_min h_max])
legend('LIN','NL')
title('Rigidezza dinamica - altezza di meato')


figure 
plot(H0*1e6,C_dynL(:,1),'b-','linewidth',2),grid on, hold on,
plot(H0_Ps5,c_NL_Ps5(:,1),'ro-','linewidth',2),grid on, hold on,
xlabel(' Air \quad gap $\quad h$ $(\mu m) $'),
ylabel(' Damping  $ \quad c$ $(\frac{N}{m})$ '),
grid on, zoom on
xlim([h_min h_max])
legend('LIN','NL')
title('Smorzamento - altezza di meato')


figure 
plot(Frequenze,(K_dynL(1,:))','b-','linewidth',2),grid on, hold on,
plot(f_Ps5,(k_NL_Ps5(1,:))','ro-','linewidth',2),grid on, hold on,
xlabel(' Frequency \quad $\quad f$ $(Hz) $'),
ylabel(' Stiffness  $ \quad k$ $(\frac{N}{m})$ '),
grid on, zoom on
legend('LIN','NL')
title('Rigidezza dinamica - frequenza')

figure 
plot(Frequenze,(C_dynL(1,:))','b-','linewidth',2),grid on, hold on,
plot(f_Ps5,(c_NL_Ps5(1,:))','ro-','linewidth',2),grid on, hold on,
xlabel(' Frequency \quad $\quad f$ $(Hz) $'),
ylabel(' Damping  $ \quad c$ $(\frac{N s}{m})$ '),
grid on, zoom on
legend('LIN','NL')
title('Smorzamento - frequenza')


Fp=F_EXT;

save Dati_Modello_linearizzato_Ps7 Ps Fp H0 W_tf 

%% Confronto Coefficienti
% %Derivate G1(P1,x(P1))
% %a1=dG1/dP1
% a1_NL=derivata(G1,P1);
% %a2=dG1/dx
% a2_NL=derivata(G1,Xv);
% 
% %Derivate G2(P1,P2,h)
% %b1=dG2/dh
% b1_NL=derivata(G2,H0);
% %b2=dG2/dP1
% b2_NL=derivata(G2,P1);
% %b3=dG2/dP2
% b3_NL=derivata(G2,P2);
% 
% %Derivate G3(P0,h)
% %c1=dG3/dh
% c1_NL=derivata(G3,H0);
% %c2=dG2/dP0
% c2_NL=derivata(G3,P0);
% 
% %Derivate di P0(h,P2)
% %k1=dP2/dP0
% k1_NL=derivata(P2,P0);
% %k2=dP2/dh
% k2_NL=derivata(P2,H0);
% 
% %Derivate di x(P1)
% %f1=dx/dP1
% f1_NL=derivata(Xv,P1);
% 
% g1_NL=(V1+Xv*pi*dm^2/4)./(R*T);
% g2_NL=(P1*pi*dm^2/4)./(R*T);
% l1_NL=(P0*A)/(R*T);
% l2_NL=(H0*A+Vg)./(R*T);
% 
% %%
% % close all
% figure 
% plot(Fm,a1_NL,'rx','linewidth',2),grid on, hold on,
% plot(Fm,a1,'b','linewidth',2),grid on, hold on,
% xlabel(' Force \quad $\quad F_p$ $( N ) $'),
% ylabel('  $ \quad a_1 $ '),
% grid on, zoom on
% xlim([F_min F_max])
% 
% figure 
% plot(Fm,a2_NL,'rx','linewidth',2),grid on, hold on,
% plot(Fm,a2,'b','linewidth',2),grid on, hold on,
% xlabel(' Force \quad $\quad F_p$ $( N ) $'),
% ylabel('  $ \quad a_2 $ '),
% grid on, zoom on
% xlim([F_min F_max])
% 
% figure 
% plot(Fm,b1_NL,'rx','linewidth',2),grid on, hold on,
% plot(Fm,b1,'b','linewidth',2),grid on, hold on,
% xlabel(' Force \quad $\quad F_p$ $( N ) $'),
% ylabel('  $ \quad b_1 $ '),
% grid on, zoom on
% xlim([F_min F_max])
% 
% figure 
% plot(Fm,b2_NL,'rx','linewidth',2),grid on, hold on,
% plot(Fm,b2,'b','linewidth',2),grid on, hold on,
% xlabel(' Force \quad $\quad F_p$ $( N ) $'),
% ylabel('  $ \quad b_2 $ '),
% grid on, zoom on
% xlim([F_min F_max])
% 
% figure 
% plot(Fm,b3_NL,'rx','linewidth',2),grid on, hold on,
% plot(Fm,b3,'b','linewidth',2),grid on, hold on,
% xlabel(' Force \quad $\quad F_p$ $( N ) $'),
% ylabel('  $ \quad b_3 $ '),
% grid on, zoom on
% xlim([F_min F_max])
% 
% figure 
% plot(Fm,c1_NL,'rx','linewidth',2),grid on, hold on,
% plot(Fm,c1,'b','linewidth',2),grid on, hold on,
% xlabel(' Force \quad $\quad F_p$ $( N ) $'),
% ylabel('  $ \quad c_1 $ '),
% grid on, zoom on
% xlim([F_min F_max])
% 
% figure 
% plot(Fm,c2_NL,'rx','linewidth',2),grid on, hold on,
% plot(Fm,c2,'b','linewidth',2),grid on, hold on,
% xlabel(' Force \quad $\quad F_p$ $( N ) $'),
% ylabel('  $ \quad c_2 $ '),
% grid on, zoom on
% xlim([F_min F_max])
% 
% % figure 
% % plot(Fm,d1_NL,'rx','linewidth',2),grid on, hold on,
% % plot(Fm,d1,'b','linewidth',2),grid on, hold on,
% % xlabel(' Force \quad $\quad F_p$ $( N ) $'),
% % ylabel('  $ \quad d_1 $ '),
% % grid on, zoom on
% % xlim([F_min F_max])
% % 
% % figure 
% % plot(Fm,d2_NL,'rx','linewidth',2),grid on, hold on,
% % plot(Fm,d2,'b','linewidth',2),grid on, hold on,
% % xlabel(' Force \quad $\quad F_p$ $( N ) $'),
% % ylabel('  $ \quad d_2 $ '),
% % grid on, zoom on
% % xlim([F_min F_max])
% 
% 
% figure 
% plot(Fm,f1_NL,'rx','linewidth',2),grid on, hold on,
% plot(Fm,f1,'b','linewidth',2),grid on, hold on,
% xlabel(' Force \quad $\quad F_p$ $( N ) $'),
% ylabel('  $ \quad f_1 $ '),
% grid on, zoom on
% xlim([F_min F_max])
% 
% figure 
% plot(Fm,g1_NL,'rx','linewidth',2),grid on, hold on,
% plot(Fm,g1c,'b','linewidth',2),grid on, hold on,
% xlabel(' Force \quad $\quad F_p$ $( N ) $'),
% ylabel('  $ \quad g_1 $ '),
% grid on, zoom on
% xlim([F_min F_max])
% 
% figure 
% plot(Fm,g2_NL,'rx','linewidth',2),grid on, hold on,
% plot(Fm,g2c,'b','linewidth',2),grid on, hold on,
% xlabel(' Force \quad $\quad F_p$ $( N ) $'),
% ylabel('  $ \quad g_2 $ '),
% grid on, zoom on
% xlim([F_min F_max])
% 
% 
% figure 
% plot(Fm,k1_NL,'rx','linewidth',2),grid on, hold on,
% plot(Fm,k1,'b','linewidth',2),grid on, hold on,
% xlabel(' Force \quad $\quad F_p$ $( N ) $'),
% ylabel('  $ \quad k_1 $ '),
% grid on, zoom on
% xlim([F_min F_max])
% 
% figure 
% plot(Fm,k2_NL,'rx','linewidth',2),grid on, hold on,
% plot(Fm,k2,'b','linewidth',2),grid on, hold on,
% xlabel(' Force \quad $\quad F_p$ $( N ) $'),
% ylabel('  $ \quad k_2 $ '),
% grid on, zoom on
% xlim([F_min F_max])
% 
% 
% figure 
% plot(Fm,l1_NL,'rx','linewidth',2),grid on, hold on,
% plot(Fm,l1,'b','linewidth',2),grid on, hold on,
% xlabel(' Force \quad $\quad F_p$ $( N ) $'),
% ylabel('  $ \quad l_1 $ '),
% grid on, zoom on
% xlim([F_min F_max])
% 
% figure 
% plot(Fm,l2_NL,'rx','linewidth',2),grid on, hold on,
% plot(Fm,l2,'b','linewidth',2),grid on, hold on,
% xlabel(' Force \quad $\quad F_p$ $( N ) $'),
% ylabel('  $ \quad l_2 $ '),
% grid on, zoom on
% xlim([F_min F_max])
% 
% 
% % 
% % % figure 
% % % plot(diff(G1),'bo','linewidth',2),grid on, hold on,
% % % plot(diff(G2),'r','linewidth',2),grid on, hold on,
% % % plot(diff(G3),'g','linewidth',2),grid on, hold on,
% % % ylabel('  $ \Delta G  $ '),
% % % grid on, zoom on
